// popup.js
document.addEventListener('DOMContentLoaded', () => {
  // chrome.runtime.sendMessage({ action: "checkVersion" });
  checkVersionOnInstall();


  // populateAddressesAndInsurance();

  document.getElementById('submitButton').addEventListener('click', (event) => {
    event.preventDefault();
    passDataToAPI();
  });

  document.getElementById('logout_btn').addEventListener('click', (event) => {
    event.preventDefault();
    logoutUser();
  });

  // Check cookies and show/hide address wrapper based on login status
chrome.runtime.sendMessage({ action: "checkCookie" }, (response) => {
  if (response.exists) {
    showAddress();
    populateAddressesAndInsurance();
  } else {
    hideAddress();
  }
});


});


function logoutUser() {
  // Ask background script to get cookie values
    chrome.runtime.sendMessage({ action: "checkCookie" }, (response) => {
      let authHeader = {};

      if (response.exists && response.cookies) {
        // Use the first cookie value directly as the Authorization header value
        const firstCookieName = Object.keys(response.cookies)[0];
        const firstCookieValue = response.cookies[firstCookieName];
        authHeader = {
          'Authorization': firstCookieValue
        };
      }

      fetch(API_LOGOUT_URL, {
        method: 'POST',  
        headers: authHeader
      })
      .then(response => {
        if (!response.ok) {
          throw new Error(`Logout failed with status: ${response.status}`);
        }
        return response.json();
      })
      .then(data => {
        chrome.runtime.sendMessage({ action: "reloadExtension" });
        // Optionally redirect or update UI
        // window.location.href = '/login';
      })
      .catch(error => {
        console.error('Error during logout:', error);
      });
    });
}

// function extractAddressesByState() {
//   const stateAbbr = [
//         'AL', 'AK', 'AZ', 'AR', 'CA', 'CO', 'CT', 'DE', 'FL', 'GA', 'HI', 'ID', 'IL', 'IN', 'IA', 'KS', 'KY', 'LA', 'ME', 'MD', 'MA', 'MI', 'MN',
//         'MS', 'MO', 'MT', 'NE', 'NV', 'NH', 'NJ', 'NM', 'NY', 'NC', 'ND', 'OH', 'OK', 'OR', 'PA', 'RI', 'SC', 'SD', 'TN', 'TX', 'UT', 'VT', 'VA',
//         'WA', 'WV', 'WI', 'WY'
//       ];

//       // US address pattern: number, street, city, state, ZIP
//       const addressRegex = new RegExp(
//         `(\\d+\\s+[^,\\n]+(?:\\s*,?\\s*Suite\\s+\\d+)?[,\\s]*[^,\\n]+[,\\s]*(?:${stateAbbr.join('|')})[,\\s]*\\d{5}(?:[,\\s]*USA)?)`,
//         'gi'
//       );

//       const results = new Set();

//       // Normalize address: lowercase, trim, remove trailing punctuation like '.' or ',' 
//       function normalizeAddress(addr) {
//         return addr.trim().replace(/[.,]$/, '');
//       }

//       // XPath to get non-empty text nodes
//       const xpath = "//text()[normalize-space(.) != '']";
//       const iterator = document.evaluate(xpath, document, null, XPathResult.ORDERED_NODE_ITERATOR_TYPE, null);

//       // Collect all text nodes into an array for indexed access
//       const textNodes = [];
//       let node = iterator.iterateNext();
//       while (node) {
//         textNodes.push(node);
//         node = iterator.iterateNext();
//       }

//       // Function to check exact "Dwelling Address" label (case-insensitive)
//       const isExactDwellingLabel = (text) => text?.trim().toLowerCase() === 'dwelling address';

//       // Find index of "Dwelling Address" node
//       let dwellingIndex = -1;
//       for (let i = 0; i < textNodes.length; i++) {
//         console.log("Checking text node:", textNodes.length);
//         if (isExactDwellingLabel(textNodes[i].textContent)) {
//           dwellingIndex = i;
//           break;
//         }
//       }

//       const scannedIndices = new Set();

//       // Step 1: Scan 10 nodes after Dwelling Address label (if found)
//       if (dwellingIndex >= 0) {
//         for (let i = dwellingIndex; i < Math.min(dwellingIndex + 10, textNodes.length); i++) {
//           console.log("Checking text node 2:", textNodes.length);
//           scannedIndices.add(i);
//           const text = textNodes[i].textContent.trim();
//           if (!text) continue;

//           const matches = text.match(addressRegex);
//           if (matches) {
//             matches.forEach((match) => results.add(normalizeAddress(match)));
//           }
//         }
//       }

//       // Step 2: Scan remaining text nodes excluding those already scanned
//       for (let i = 0; i < textNodes.length; i++) {
//         if (scannedIndices.has(i)) continue;

//         const text = textNodes[i].textContent.trim();
//         if (text.length > 100) continue;  // Skip overly long text nodes (like scripts)
//         if (!text) continue;

//         let matches = false;
//         const zipRegex = /\b\d{5}\b/;
//         if (text.match(zipRegex)) {
//           matches = text.match(addressRegex);
//         }
//         if (matches) {
//           matches.forEach((match) => results.add(normalizeAddress(match)));
//         }
//       }

//       // Step 3: Handle 'lightning-formatted-address' elements
//       const addressElements = document.querySelectorAll('lightning-formatted-address');
//       addressElements.forEach((element) => {
//         const addressParts = Array.from(element.querySelectorAll('div')).map(div => div.textContent.trim()).join(', ');
//         const matches = addressParts.match(addressRegex);
//         if (matches) {
//           matches.forEach((match) => results.add(normalizeAddress(match)));
//         }
//       });

//       return Array.from(results);
// }

function extractAddressesByState() {
  const stateAbbr = [
    'AL','AK','AZ','AR','CA','CO','CT','DE','FL','GA','HI','ID','IL','IN','IA','KS','KY','LA',
    'ME','MD','MA','MI','MN','MS','MO','MT','NE','NV','NH','NJ','NM','NY','NC','ND','OH','OK',
    'OR','PA','RI','SC','SD','TN','TX','UT','VT','VA','WA','WV','WI','WY'
  ];

  // UPDATED: supports line breaks + ZIP+4
  const addressRegex = new RegExp(
    `(\\d+\\s+[^,\\n]+` +                         // street
    `(?:\\s*,?\\s*Suite\\s+\\d+)?` +
    `[\\s,]+[^,\\n]+` +                          // city
    `[\\s,]+(?:${stateAbbr.join('|')})` +        // state
    `[\\s,]+\\d{5}(?:-\\d{4})?` +                // ZIP or ZIP+4
    `(?:[\\s,]*USA)?)`,
    'gi'
  );

  const results = new Set();

  function normalizeAddress(addr) {
    return addr.trim().replace(/[.,]$/, '');
  }

  const xpath = "//text()[normalize-space(.) != '']";
  const iterator = document.evaluate(xpath, document, null, XPathResult.ORDERED_NODE_ITERATOR_TYPE, null);

  const textNodes = [];
  let node = iterator.iterateNext();
  while (node) {
    textNodes.push(node);
    node = iterator.iterateNext();
  }

  const isExactDwellingLabel = (text) =>
    text?.trim().toLowerCase() === 'dwelling address';

  let dwellingIndex = -1;
  for (let i = 0; i < textNodes.length; i++) {
    if (isExactDwellingLabel(textNodes[i].textContent)) {
      dwellingIndex = i;
      break;
    }
  }

  const scannedIndices = new Set();

  // Helper: merge up to 3 adjacent short text nodes
  function getCombinedText(startIndex, maxNodes = 3) {
    let combined = '';
    for (let i = startIndex; i < Math.min(startIndex + maxNodes, textNodes.length); i++) {
      const t = textNodes[i].textContent.trim();
      if (!t || t.length > 60) break;
      combined += (combined ? ', ' : '') + t;
    }
    return combined;
  }

  // Step 1: Scan near "Dwelling Address"
  if (dwellingIndex >= 0) {
    for (let i = dwellingIndex; i < Math.min(dwellingIndex + 10, textNodes.length); i++) {
      scannedIndices.add(i);
      const combinedText = getCombinedText(i);

      const matches = combinedText.match(addressRegex);
      if (matches) {
        matches.forEach(m => results.add(normalizeAddress(m)));
      }
    }
  }

  // Step 2: Scan remaining nodes (combined)
  for (let i = 0; i < textNodes.length; i++) {
    if (scannedIndices.has(i)) continue;

    const combinedText = getCombinedText(i);
    if (!combinedText) continue;

    const matches = combinedText.match(addressRegex);
    if (matches) {
      matches.forEach(m => results.add(normalizeAddress(m)));
    }
  }

  // Step 3: lightning-formatted-address (unchanged)
  const addressElements = document.querySelectorAll('lightning-formatted-address');
  addressElements.forEach(el => {
    const addressParts = Array.from(el.querySelectorAll('div'))
      .map(div => div.textContent.trim())
      .join(', ');

    const matches = addressParts.match(addressRegex);
    if (matches) {
      matches.forEach(m => results.add(normalizeAddress(m)));
    }
  });

  return Array.from(results);
}


let allAddresses = [];
let selectedAddresses = new Map(); // key: row index, value: selected address

// Function to populate addresses and insurance types in the dropdowns
function populateAddressesAndInsurance() {
  const loader = document.getElementById('loader');
  if (loader) loader.style.display = 'block'; // Show loader

  chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
    const tab = tabs[0];
    if (!tab || !tab.url.startsWith("http")) {
      // console.warn("Cannot run on non-web page:", tab?.url);
      if (loader) loader.style.display = 'none';
      return; // skip chrome://, file://, or internal pages
    }
    chrome.scripting.executeScript({
      target: { tabId: tabs[0].id },
      func: extractAddressesByState
    }, (results) => {
      if (loader) loader.style.display = 'none';
      allAddresses = results[0].result;
      const container = document.getElementById('dropdownContainer');
      container.innerHTML = '';

      const addMoreBtn = document.getElementById('addMore');
      if (addMoreBtn) addMoreBtn.style.display = 'none';

      if (allAddresses.length === 0) {
        container.textContent = 'No addresses found.';
        document.querySelector('.submit-btn-wrap').style.display = 'none';
        
        // Tell background to stop flashing
        chrome.runtime.sendMessage({ action: 'stopFlashing' });
        return;
      }

      if(document.querySelectorAll('.dropdown-row').length === allAddresses.length) {
            addMoreBtn.style.display = 'none';
      }

      // Tell background to start flashing

      chrome.runtime.sendMessage({ action: 'startFlashing' });

      document.querySelector('.submit-btn-wrap').style.display = 'block';

      // Show "Add More" button if multiple addresses
      if (allAddresses.length > 1 && addMoreBtn) {
        addMoreBtn.style.display = 'inline-block';
        addMoreBtn.onclick = () => {
          const currentCount = document.querySelectorAll('.dropdown-row').length;
          addAddressRow(currentCount);
        };
      }

      addAddressRow(0);
    });
  });
}


function addAddressRow(index) {
  const row = document.createElement('div');
  row.className = 'dropdown-row';

  const insuranceSelectWrap1 = document.createElement('div');
  insuranceSelectWrap1.className = 'insuranceSelectWrap';

  const addressSelectLabel = document.createElement('label');
  addressSelectLabel.innerText = 'Address:';

  const addressSelect = document.createElement('select');
  addressSelect.className = 'addressDropdown form-select';
  addressSelect.dataset.row = index;

  updateAddressOptions(addressSelect, null);

  addressSelect.addEventListener('change', () => {
    const rowIdx = parseInt(addressSelect.dataset.row);
    const newSelected = addressSelect.value;
    selectedAddresses.set(rowIdx, newSelected);

    document.querySelectorAll('.addressDropdown').forEach((dropdown) => {
      const currentRow = parseInt(dropdown.dataset.row);
      const currentValue = selectedAddresses.get(currentRow) || null;
      updateAddressOptions(dropdown, currentValue);
    });
  });

  insuranceSelectWrap1.appendChild(addressSelectLabel);
  insuranceSelectWrap1.appendChild(addressSelect);

  const insuranceSelectWrap2 = document.createElement('div');
  insuranceSelectWrap2.className = 'insuranceSelectWrap';

  const insuranceSelectLabel = document.createElement('label');
  insuranceSelectLabel.setAttribute('for', `insurance-${index}`);
  insuranceSelectLabel.innerText = 'Insurance Types:';

  const insuranceSelect = document.createElement('select');
  insuranceSelect.className = 'insuranceDropdown form-select';
  insuranceSelect.id = `insurance-${index}`;
  insuranceSelect.multiple = true;
  insuranceSelect.size = 4;

  insuranceSelectWrap2.appendChild(insuranceSelectLabel);
  insuranceSelectWrap2.appendChild(insuranceSelect);

  row.appendChild(insuranceSelectWrap1);
  row.appendChild(insuranceSelectWrap2);

  const container = document.getElementById('dropdownContainer');
  container.appendChild(row);

  populateInsuranceTypes(insuranceSelect).then(() => {
    $(insuranceSelect).select2({
      placeholder: "Select insurance types",
      width: '100%',
      closeOnSelect: true,
      dropdownPosition: 'below'
    });
  });
}

// Function to update address options in the dropdown
function updateAddressOptions(dropdown, selectedValue) {
  const usedAddresses = Array.from(selectedAddresses.values()).filter(val => val !== selectedValue);
  dropdown.innerHTML = '';

  const defaultOption = document.createElement('option');
  defaultOption.value = '';
  defaultOption.textContent = '-- Select address --';
  dropdown.appendChild(defaultOption);

  allAddresses.forEach(address => {
    const option = document.createElement('option');
    option.value = address;
    option.textContent = address;
    if (usedAddresses.includes(address)) {
      option.disabled = true;
    }
    dropdown.appendChild(option);
  });

  // Re-set value to selected one (if any)
  if (selectedValue) {
    dropdown.value = selectedValue;
  }
}


// Function to populate insurance types in the dropdown
function populateInsuranceTypes(dropdownElement) {
  return new Promise((resolve) => {
    dropdownElement.innerHTML = '';
    const loadingOption = document.createElement('option');
    loadingOption.textContent = 'Loading...';
    loadingOption.disabled = true;
    dropdownElement.appendChild(loadingOption);

    // Ask background script to get cookie values
    chrome.runtime.sendMessage({ action: "checkCookie" }, (response) => {
      let authHeader = {};

      if (response.exists && response.cookies) {
        // Use the first cookie value directly as the Authorization header value
        const firstCookieName = Object.keys(response.cookies)[0];
        const firstCookieValue = response.cookies[firstCookieName];
        authHeader = {
          'Authorization': firstCookieValue
        };
      }

      // Fetch API with Authorization header (raw cookie value)
      fetch(API_URL, {
        headers: authHeader
      })
        .then(response => {
          if (!response.ok) throw new Error(`HTTP error! status: ${response.status}`);
          return response.json();
        })
        .then(data => {
          dropdownElement.innerHTML = '';
          if (data.status && Array.isArray(data.items)) {
            if (data.items.length === 0) {
              const option = document.createElement('option');
              option.textContent = 'No insurance types available.';
              dropdownElement.appendChild(option);
            } else {
              data.items.forEach(item => {
                const option = document.createElement('option');
                option.value = item;
                option.textContent = item;
                dropdownElement.appendChild(option);
              });
            }
          } else {
            const option = document.createElement('option');
            option.textContent = 'Error loading insurance types';
            dropdownElement.appendChild(option);
          }
          resolve();
        })
        .catch(error => {
          console.error('Failed to fetch insurance types:', error);
          dropdownElement.innerHTML = '';
          const option = document.createElement('option');
          option.textContent = 'Error loading insurance types';
          dropdownElement.appendChild(option);
          resolve();
        });
    });
  });
}

// Function to pass data to API and handle responses
function passDataToAPI() {
  const rows = document.querySelectorAll('.dropdown-row');
  const requests = [];

  const formErrors = document.getElementById('formErrors');
  formErrors.textContent = '';

  const insuredNameInput = document.getElementById('insuredName');
  const insuredName = insuredNameInput?.value.trim();

  if (!insuredName) {
    formErrors.textContent = 'Please enter the insured name.\n';
    return;
  }

  rows.forEach((row, rowIndex) => {
    const addressSelect = row.querySelector('.addressDropdown');
    const address = addressSelect?.value;

    const selectedOptions = Array.from(row.querySelector('.insuranceDropdown')?.selectedOptions || []);
    const insurances = selectedOptions.map(option => option.value);

    if (!address || insurances.length === 0) {
      return;
    }

    insurances.forEach((insurance) => {
      const url = `${API_ADDRESS_URL}?address=${encodeURIComponent(address)}&insuranceType=${encodeURIComponent(insurance)}&insuredName=${encodeURIComponent(insuredName)}`;
      requests.push({ rowIndex, url });
    });
  });

  if (requests.length === 0) {
    formErrors.textContent = 'No valid rows to submit. Please fill in at least one complete row.';
    return;
  }

  const submitButton = document.getElementById('submitButton');
  submitButton.disabled = true;
  const originalText = submitButton.textContent;
  submitButton.textContent = 'Submitting...';

  Promise.all(
    requests.map(({ rowIndex, url }) =>
      fetch(url)
        .then(res => res.json())
        .then(data => ({ rowIndex, data }))
        .catch(err => ({ rowIndex, data: { error: err.message } }))
    )
  ).then(responses => {
    responses.forEach(({ rowIndex, data }) => {
      if (data.status && data.url) {
        chrome.tabs.create({ url: data.url });
      } else {
        formErrors.textContent += `Row ${rowIndex + 1}: ${data.message || data.error || 'API error or network issue'}\n`;
      }
    });

    submitButton.disabled = false;
    submitButton.textContent = originalText;
  }).catch(error => {
    console.error('Batch fetch error:', error);
    formErrors.textContent = 'Network error occurred.';
    submitButton.disabled = false;
    submitButton.textContent = originalText;
  });
}



// Function to show address wrapper and hide header link
function showAddress() {
  const addressWrapper = document.getElementById("address-wrapper");
  const addressHeader = document.getElementById("address-header");

  if (addressWrapper) addressWrapper.style.display = "block";
  if (addressHeader) addressHeader.style.display = "none";
  
}

// Function to hide address wrapper and reset header link
function hideAddress() {
  const addressWrapper = document.getElementById("address-wrapper");
  const addressHeaderLink = document.querySelector(".address-header .login-text a");

  if (addressHeaderLink) addressHeaderLink.href = API_AUTH_URL;
  if (addressWrapper) addressWrapper.style.display = "none";

}


// popup.js
let latestDownloadUrl = null; // Make sure this exists globally
let latestEnv = "staging";


document.addEventListener('DOMContentLoaded', () => {
  // checkVersionOnInstall();
});

function checkVersionOnInstall() {
  // Get the current version from the manifest
  const currentVersion = chrome.runtime.getManifest().version;
  console.log("currentVersion",currentVersion)
  // Same logic, fetch the version from the server or any external source
  fetch('https://pti.agency/extension-version.json?cache=' + Date.now())  // Your API endpoint
    .then(response => response.json())
    .then(data => {
      const latestVersion = data.version;
      const releasenotes = data.releasenotes || "";
      latestEnv = data.env || "staging";
      latestDownloadUrl = data.download_url;

      console.log("latestVersion",latestVersion)
      console.log("currentVersion",currentVersion)

      // Save env for later use
      chrome.storage.local.set({ ENV: latestEnv });

      if (!latestDownloadUrl) {
        console.error("download_url missing in JSON");
        return;
      }
      const notificationId = "versionCheck_" + Date.now();

      if (currentVersion !== latestVersion) {
        chrome.runtime.sendMessage({
          action: "updateAvailable",
          value: true
        });
       chrome.notifications.create(notificationId, {
          type: "basic",
          iconUrl: "icon_active_no_background.png",
          title: "New Version Available!",
          message: `Click to download v${latestVersion}\n${releasenotes}`,
          priority: 2
        });
      showUpdateMessage(latestVersion, releasenotes);

      } else {
        chrome.runtime.sendMessage({
          action: "updateAvailable",
          value: false
        });
        hideUpdateMessage()
      }
    })
    .catch(error => {
      // console.error('Error fetching version info:', error);
      // document.getElementById('version-info').textContent = 'Error checking for updates';
    });
}


// function showUpdateMessage(latestVersion, releasenotes) {
//   const container = document.querySelector(".login-text");

//   // Remove old message if exists
//   const oldMsg = document.querySelector(".extension-update-message");
//   if (oldMsg) oldMsg.remove();

//   const msgBox = document.createElement("div");
//   msgBox.className = "extension-update-message";
//   msgBox.style.marginTop = "12px";
//   msgBox.style.padding = "10px";
//   msgBox.style.background = "#fff3cd";
//   msgBox.style.border = "1px solid #ffeeba";
//   msgBox.style.borderRadius = "5px";
//   msgBox.style.color = "#856404";

//   msgBox.innerHTML = `
//     <strong>New Extension Version Available! <a href="https://pti.agency/ptintelliquote/" target="_blank">Click Here!</a></strong><br>
//     OR <br> Click the Chrome notification to download v${latestVersion}.<br>
//     <em>${releasenotes}</em>
//   `;

//   container.appendChild(msgBox);
// }

function showUpdateMessage(latestVersion, releasenotes) {
  // Remove old message if exists
  const oldMsg = document.querySelector(".extension-update-message");
  if (oldMsg) oldMsg.remove();
  console.log("Checking cookie for update message placement.");
  chrome.runtime.sendMessage({ action: "checkCookie" }, (response) => {
    let container;
    console.log("Response cookie check:", response);
    if (response?.exists) {
      // ✅ Logged-in user → show under address fields
      container = document.getElementById("address-wrapper");
    } else {
      // ✅ Logged-out user → existing behavior
      container = document.querySelector(".login-text");
    }

    if (!container) return;

    const msgBox = document.createElement("div");
    msgBox.className = "extension-update-message";
    msgBox.style.marginTop = "12px";
    msgBox.style.padding = "10px";
    msgBox.style.background = "#fff3cd";
    msgBox.style.border = "1px solid #ffeeba";
    msgBox.style.borderRadius = "5px";
    msgBox.style.color = "#856404";
    msgBox.style.textAlign = "center";
    msgBox.innerHTML = `
      <strong>
        New Extension Version Available!
        <a href="https://pti.agency/ptintelliquote/" target="_blank">Click Here!</a>
      </strong><br>
      OR<br>
      Click the Chrome notification to download v${latestVersion}.<br>
      <em>${releasenotes}</em>
    `;

    container.appendChild(msgBox);
  });
}


function hideUpdateMessage() {
  const oldMsg = document.querySelector(".extension-update-message");
  if (oldMsg) oldMsg.remove();
}