// Starts flashing immediately and never stops
let iconToggle = false;
let updateAvailable = false;

// setInterval(() => {
//   iconToggle = !iconToggle;
//   const iconPath = iconToggle ? 'icon_active.png' : 'icon_inactive.png';
//   chrome.action.setIcon({ path: iconPath });
// }, 500);
let flashInterval = null;
let hasNotified = false;  // Prevent repeated notifications


function startFlashing() {
  if (updateAvailable) return; // don't flash if update available
  if (flashInterval) return; // already flashing
  flashInterval = setInterval(() => {
    iconToggle = !iconToggle;
    const iconPath = iconToggle ? 'icon_active_no_background.png' : 'icon_inactive_no_background.png';
    console.log("Flashing icon:", iconPath);
    chrome.action.setIcon({ path: iconPath });
  }, 500);
}

function stopFlashing() {
  if (flashInterval) {
    clearInterval(flashInterval);
    flashInterval = null;
    chrome.action.setIcon({ path: 'icon_inactive_no_background.png' }); // reset to default
  }

  chrome.action.setIcon({
    path: updateAvailable
      ? 'icon_active_red.png'
      : 'icon_inactive_no_background.png'
  });

  // if (!updateAvailable) {
  //   chrome.action.setIcon({ path: 'icon_active_red.png' });
  // }
}

// Listen for commands from popup.js
chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
  if (message.action === 'startFlashing') {
    startFlashing();
  } else if (message.action === 'stopFlashing') {
    stopFlashing();
  } else if(message.action === 'updateAvailable') {
     updateAvailable = message.value;
    console.log("Update available status:", updateAvailable);
    if (updateAvailable) {
      // Stop flashing & force update icon
      stopFlashing();
      chrome.action.setIcon({
        path: 'icon_active_red.png'
      });

      chrome.storage.local.set({ UPDATE_AVAILABLE: true });
    } else {
      chrome.storage.local.remove("UPDATE_AVAILABLE");
      chrome.action.setIcon({
        path: 'icon_inactive_no_background.png'
      });
    }
  }
});

chrome.runtime.onStartup.addListener(() => {
  chrome.storage.local.get(["UPDATE_AVAILABLE"], (res) => {
    if (res.UPDATE_AVAILABLE) {
      updateAvailable = true;
      chrome.action.setIcon({
        path: 'icon_active_red.png'
      });
    }
  });
});


chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  if (request.action === "checkCookie") {

    // Get ENV stored earlier (staging, development, production)
    chrome.storage.local.get(["ENV"], (result) => {
      const env = result.ENV || "staging"; // default fallback
      let prefix = "";

      // Map environment → cookie suffix
      if (env === "staging") prefix = "uat";
      else if (env === "development") prefix = "demo";
      else if (env === "production") prefix = "live";

      // Build cookie names dynamically
      const cookieNames = [
        `authLive_${prefix}`,
        `authLiveUser_${prefix}`
      ];

      // Select correct URL based on environment
      const envUrlMap = {
        staging: "https://uatportal.pti.agency",
        development: "https://devportal.pti.agency",
        production: "https://portal.pti.agency"
      };

      const url = envUrlMap[env];

      const cookieData = {};

      chrome.cookies.getAll({ url }, (cookies) => {
        cookies.forEach(cookie => {
          if (cookieNames.includes(cookie.name)) {
            cookieData[cookie.name] = cookie.value;
          }
        });

        if (Object.keys(cookieData).length > 0) {
          sendResponse({ exists: true, cookies: cookieData });
        } else {
          sendResponse({ exists: false, cookies: {} });
        }
      });
    });

    return true; // async
  }
});


chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  if (request.action === "reloadExtension") {
    chrome.runtime.reload();
  }
});

function checkTabForAddresses(tabId) {
  chrome.scripting.executeScript({
    target: { tabId },
    func: () => {
      const stateAbbr = [
        'AL','AK','AZ','AR','CA','CO','CT','DE','FL','GA','HI','ID','IL','IN','IA','KS','KY','LA',
        'ME','MD','MA','MI','MN','MS','MO','MT','NE','NV','NH','NJ','NM','NY','NC','ND','OH','OK',
        'OR','PA','RI','SC','SD','TN','TX','UT','VT','VA','WA','WV','WI','WY'
      ];

      // UPDATED: supports line breaks + ZIP+4
      const addressRegex = new RegExp(
        `(\\d+\\s+[^,\\n]+` +                         // street
        `(?:\\s*,?\\s*Suite\\s+\\d+)?` +
        `[\\s,]+[^,\\n]+` +                          // city
        `[\\s,]+(?:${stateAbbr.join('|')})` +        // state
        `[\\s,]+\\d{5}(?:-\\d{4})?` +                // ZIP or ZIP+4
        `(?:[\\s,]*USA)?)`,
        'gi'
      );

      const results = new Set();

      function normalizeAddress(addr) {
        return addr.trim().replace(/[.,]$/, '');
      }

      const xpath = "//text()[normalize-space(.) != '']";
      const iterator = document.evaluate(xpath, document, null, XPathResult.ORDERED_NODE_ITERATOR_TYPE, null);

      const textNodes = [];
      let node = iterator.iterateNext();
      while (node) {
        textNodes.push(node);
        node = iterator.iterateNext();
      }

      const isExactDwellingLabel = (text) =>
        text?.trim().toLowerCase() === 'dwelling address';

      let dwellingIndex = -1;
      for (let i = 0; i < textNodes.length; i++) {
        if (isExactDwellingLabel(textNodes[i].textContent)) {
          dwellingIndex = i;
          break;
        }
      }

      const scannedIndices = new Set();

      // NEW: combine adjacent short text nodes (fixes <br> addresses)
      function getCombinedText(startIndex, maxNodes = 3) {
        let combined = '';
        for (let i = startIndex; i < Math.min(startIndex + maxNodes, textNodes.length); i++) {
          const t = textNodes[i].textContent.trim();
          if (!t || t.length > 60) break;
          combined += (combined ? ', ' : '') + t;
        }
        return combined;
      }

      // Step 1: Scan near "Dwelling Address"
      if (dwellingIndex >= 0) {
        for (let i = dwellingIndex; i < Math.min(dwellingIndex + 10, textNodes.length); i++) {
          scannedIndices.add(i);
          const combinedText = getCombinedText(i);

          const matches = combinedText.match(addressRegex);
          if (matches) {
            matches.forEach(m => results.add(normalizeAddress(m)));
          }
        }
      }

      // Step 2: Scan remaining nodes
      for (let i = 0; i < textNodes.length; i++) {
        if (scannedIndices.has(i)) continue;

        const combinedText = getCombinedText(i);
        if (!combinedText) continue;

        const matches = combinedText.match(addressRegex);
        if (matches) {
          matches.forEach(m => results.add(normalizeAddress(m)));
        }
      }

      // Step 3: lightning-formatted-address (unchanged)
      const addressElements = document.querySelectorAll('lightning-formatted-address');
      addressElements.forEach((element) => {
        const addressParts = Array.from(element.querySelectorAll('div'))
          .map(div => div.textContent.trim())
          .join(', ');

        const matches = addressParts.match(addressRegex);
        if (matches) {
          matches.forEach(m => results.add(normalizeAddress(m)));
        }
      });

      return Array.from(results);
    }
  }, (results) => {
    if (chrome.runtime.lastError || !results || !results[0]) {
      stopFlashing();
      return;
    }

    const addresses = results[0].result;
    if (addresses && addresses.length > 0) {
      startFlashing();
    } else {
      stopFlashing();
    }
  });
}




function checkVersionOnInstall() {
  return new Promise((resolve) => {  // <-- wrap in Promise
    const currentVersion = chrome.runtime.getManifest().version;
    console.log("bg currentVersion", currentVersion);

    fetch('https://pti.agency/extension-version.json?cache=' + Date.now())
      .then(response => response.json())
      .then(data => {
        const latestVersion = data.version;
        const releasenotes = data.releasenotes || "";
        const latestEnv = data.env || "staging";
        latestDownloadUrl = data.download_url;

        console.log("bg latestVersion", latestVersion);
        console.log("bg currentVersion", currentVersion);

        // Save env for later use
        chrome.storage.local.set({ ENV: latestEnv });

        if (!latestDownloadUrl) {
          console.error("download_url missing in JSON");
          resolve(false); // treat missing download URL as "not OK"
          return;
        }

        if (currentVersion !== latestVersion) {
          // Update available → show red icon
          chrome.action.setIcon({ path: 'icon_active_red.png' });
          resolve(false); // do NOT run address check
        } else {
          resolve(true); // version OK → allow address check
        }
      })
      .catch(error => {
        console.error('Error fetching version info:', error);
        resolve(false); // on error, treat as "not OK"
      });
  });
}



// chrome.tabs.onActivated.addListener(({ tabId }) => {
//   checkVersionOnInstall().then((versionOk) => {
//     if (versionOk) {
//       checkTabForAddresses(tabId);
//     }
//   });
// });
chrome.tabs.onActivated.addListener(({ tabId }) => {
  chrome.tabs.get(tabId, (tab) => {
    if (!tab.url.startsWith("http")) return; // skip chrome:// and other non-http URLs
    checkVersionOnInstall().then((versionOk) => {
      if (versionOk) checkTabForAddresses(tabId);
    });
  });
});

chrome.tabs.onUpdated.addListener((tabId, changeInfo, tab) => {
  if (tab.active && changeInfo.status === 'complete') {
    if (!tab.url.startsWith("http")) return;
    checkVersionOnInstall().then((versionOk) => {
      if (versionOk) {
        checkTabForAddresses(tabId);
      }
    });
  }
});


let latestDownloadUrl = null; // Make sure this exists globally
chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
  // let isNotified = false;
  if (message.action === "checkVersion") {
    // if(!isNotified) {
      //checkVersion();
    // }
  }
});


// function checkVersion() {
//   const currentVersion = chrome.runtime.getManifest().version;

//   fetch("https://pti.agency/extension-version.json?cache=no-cache")
//     .then(res => res.json())
//     .then(data => {
//       const latestVersion = data.version;
//       const releasenotes = data.releasenotes || "";

//       latestDownloadUrl = data.download_url;

//       if (!latestDownloadUrl) {
//         console.error("download_url missing in JSON");
//         return;
//       }

//       // Create a fresh unique notification ID every time
//       const notificationId = "versionCheck_" + Date.now();

//       if (currentVersion !== latestVersion) {
//         chrome.notifications.create(notificationId, {
//           type: "basic",
//           iconUrl: "icon_active_no_background.png",
//           title: "New Version Available!",
//           message: `Click to download v${latestVersion}\n${releasenotes}`,
//           priority: 2
//         });

//         // Save update info in local storage
//         // chrome.storage.local.set({
//         //   updateAvailable: true,
//         //   latestVersion: latestVersion,
//         //   releasenotes: releasenotes
//         // });

//         // // Notify popup (if it is open)
//         // chrome.runtime.sendMessage({
//         //   type: "UPDATE_AVAILABLE",
//         //   latestVersion,
//         //   releasenotes
//         // });

//         // isNotified = true;
//       } else {
//         // chrome.storage.local.remove("UPDATE_AVAILABLE");
//         // chrome.action.setIcon({
//         //   path: 'icon_inactive_no_background.png'
//         // });
//         // Clear update info
//         // chrome.storage.local.set({
//         //   updateAvailable: false
//         // });

//         // // Tell popup to REMOVE the message
//         // chrome.runtime.sendMessage({
//         //   type: "NO_UPDATE"
//         // });
//         // chrome.notifications.create(notificationId, {
//         //   type: "basic",
//         //   iconUrl: "icon_active_no_background.png",
//         //   title: "Up to date",
//         //   message: `Current version: ${currentVersion}`,
//         //   priority: 0
//         // });
//       }
//     })
//     .catch(err => {
//       console.error("Error checking version:", err);
//     });
// }

// Notification click = open download
// chrome.notifications.onClicked.addListener((notificationId) => {
//   if (notificationId.startsWith("versionCheck_") && latestDownloadUrl) {
//     chrome.tabs.create({ url: latestDownloadUrl });
//   }
//   //isNotified = false; // Reset notification flag after click
// });


chrome.notifications.onClicked.addListener((notificationId) => {
  if (!notificationId.startsWith("versionCheck_")) return;

  chrome.storage.local.get(["ENV"], (result) => {
    // Use stored download URL if you want environment-based logic
    chrome.tabs.create({
      url: "https://pti.agency/ptintelliquote/"
    });
  });
});

function showUpdateMessage(latestVersion, releasenotes) {
  // Remove old message if exists
  const oldMsg = document.querySelector(".extension-update-message");
  if (oldMsg) oldMsg.remove();
  console.log("Checking cookie for update message placement.");
  chrome.runtime.sendMessage({ action: "checkCookie" }, (response) => {
    let container;
    console.log("Response cookie check:", response);
    if (response?.exists) {
      // ✅ Logged-in user → show under address fields
      container = document.getElementById("address-wrapper");
    } else {
      // ✅ Logged-out user → existing behavior
      container = document.querySelector(".login-text");
    }

    if (!container) return;

    const msgBox = document.createElement("div");
    msgBox.className = "extension-update-message";
    msgBox.style.marginTop = "12px";
    msgBox.style.padding = "10px";
    msgBox.style.background = "#fff3cd";
    msgBox.style.border = "1px solid #ffeeba";
    msgBox.style.borderRadius = "5px";
    msgBox.style.color = "#856404";
    msgBox.style.textAlign = "center";
    msgBox.innerHTML = `
      <strong>
        New Extension Version Available!
        <a href="https://pti.agency/ptintelliquote/" target="_blank">Click Here!</a>
      </strong><br>
      OR<br>
      Click the Chrome notification to download v${latestVersion}.<br>
      <em>${releasenotes}</em>
    `;

    container.appendChild(msgBox);
  });
}


function hideUpdateMessage() {
  const oldMsg = document.querySelector(".extension-update-message");
  if (oldMsg) oldMsg.remove();
}