// Starts flashing immediately and never stops
let iconToggle = false;
let updateAvailable = false;

// setInterval(() => {
//   iconToggle = !iconToggle;
//   const iconPath = iconToggle ? 'icon_active.png' : 'icon_inactive.png';
//   chrome.action.setIcon({ path: iconPath });
// }, 500);
let flashInterval = null;
let hasNotified = false;  // Prevent repeated notifications


function startFlashing() {
  if (updateAvailable) return; // don't flash if update available
  if (flashInterval) return; // already flashing
  flashInterval = setInterval(() => {
    iconToggle = !iconToggle;
    const iconPath = iconToggle ? 'icon_active_no_background.png' : 'icon_inactive_no_background.png';
    chrome.action.setIcon({ path: iconPath });
  }, 500);
}

function stopFlashing() {
  if (flashInterval) {
    clearInterval(flashInterval);
    flashInterval = null;
    chrome.action.setIcon({ path: 'icon_inactive_no_background.png' }); // reset to default
  }

  if (!updateAvailable) {
    chrome.action.setIcon({ path: 'icon_active_red.png' });
  }
}

// Listen for commands from popup.js
chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
  if (message.action === 'startFlashing') {
    startFlashing();
  } else if (message.action === 'stopFlashing') {
    stopFlashing();
  } else if(message.action === 'updateAvailable') {
     updateAvailable = message.value;

    if (updateAvailable) {
      // Stop flashing & force update icon
      stopFlashing();
      chrome.action.setIcon({
        path: 'icon_active_red.png'
      });

      chrome.storage.local.set({ UPDATE_AVAILABLE: true });
    } else {
      chrome.storage.local.remove("UPDATE_AVAILABLE");
      chrome.action.setIcon({
        path: 'icon_inactive_no_background.png'
      });
    }
  }
});

chrome.runtime.onStartup.addListener(() => {
  chrome.storage.local.get(["UPDATE_AVAILABLE"], (res) => {
    if (res.UPDATE_AVAILABLE) {
      updateAvailable = true;
      chrome.action.setIcon({
        path: 'icon_active_red.png'
      });
    }
  });
});


// chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
//   if (request.action === "checkCookie") {
//     const cookieNames = [
//       "authLive_uat",
//       "authLiveUser_uat",
//       "authLive_demo",
//       "authLiveUser_demo",
//       "authLive_live",
//       "authLiveUser_live"
//     ];

//     const urls = [
//       "https://devportal.pti.agency",
//       "https://uatportal.pti.agency",
//       "https://portal.pti.agency"
//     ];

//     const cookieData = {};
//     let pending = urls.length;

//     urls.forEach(url => {
//       chrome.cookies.getAll({ url }, (cookies) => {
//         cookies.forEach(cookie => {
//           if (cookieNames.includes(cookie.name)) {
//             cookieData[cookie.name] = cookie.value;
//           }
//         });

//         pending--;

//         if (pending === 0) {
//           if (Object.keys(cookieData).length > 0) {
//             sendResponse({ exists: true, cookies: cookieData });
//           } else {
//             sendResponse({ exists: false, cookies: {} });
//           }
//         }
//       });
//     });

//     return true; // Async response
//   }
// });


chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  if (request.action === "checkCookie") {

    // Get ENV stored earlier (staging, development, production)
    chrome.storage.local.get(["ENV"], (result) => {
      const env = result.ENV || "staging"; // default fallback
      let prefix = "";

      // Map environment → cookie suffix
      if (env === "staging") prefix = "uat";
      else if (env === "development") prefix = "demo";
      else if (env === "production") prefix = "live";

      // Build cookie names dynamically
      const cookieNames = [
        `authLive_${prefix}`,
        `authLiveUser_${prefix}`
      ];

      // Select correct URL based on environment
      const envUrlMap = {
        staging: "https://uatportal.pti.agency",
        development: "https://devportal.pti.agency",
        production: "https://portal.pti.agency"
      };

      const url = envUrlMap[env];

      const cookieData = {};

      chrome.cookies.getAll({ url }, (cookies) => {
        cookies.forEach(cookie => {
          if (cookieNames.includes(cookie.name)) {
            cookieData[cookie.name] = cookie.value;
          }
        });

        if (Object.keys(cookieData).length > 0) {
          sendResponse({ exists: true, cookies: cookieData });
        } else {
          sendResponse({ exists: false, cookies: {} });
        }
      });
    });

    return true; // async
  }
});


chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  if (request.action === "reloadExtension") {
    chrome.runtime.reload();
  }
});

function checkTabForAddresses(tabId) {
  chrome.scripting.executeScript({
    target: { tabId },
    func: () => {
      const stateAbbr = [
        'AL', 'AK', 'AZ', 'AR', 'CA', 'CO', 'CT', 'DE', 'FL', 'GA', 'HI', 'ID', 'IL', 'IN', 'IA', 'KS', 'KY', 'LA', 'ME', 'MD', 'MA', 'MI', 'MN',
        'MS', 'MO', 'MT', 'NE', 'NV', 'NH', 'NJ', 'NM', 'NY', 'NC', 'ND', 'OH', 'OK', 'OR', 'PA', 'RI', 'SC', 'SD', 'TN', 'TX', 'UT', 'VT', 'VA',
        'WA', 'WV', 'WI', 'WY'
      ];

      // US address pattern: number, street, city, state, ZIP
      const addressRegex = new RegExp(
        `(\\d+\\s+[^,\\n]+(?:\\s*,?\\s*Suite\\s+\\d+)?[,\\s]*[^,\\n]+[,\\s]*(?:${stateAbbr.join('|')})[,\\s]*\\d{5}(?:[,\\s]*USA)?)`,
        'gi'
      );

      const results = new Set();

      // Normalize address: lowercase, trim, remove trailing punctuation like '.' or ',' 
      function normalizeAddress(addr) {
        return addr.trim().replace(/[.,]$/, '');
      }

      // XPath to get non-empty text nodes
      const xpath = "//text()[normalize-space(.) != '']";
      const iterator = document.evaluate(xpath, document, null, XPathResult.ORDERED_NODE_ITERATOR_TYPE, null);

      // Collect all text nodes into an array for indexed access
      const textNodes = [];
      let node = iterator.iterateNext();
      while (node) {
        textNodes.push(node);
        node = iterator.iterateNext();
      }

      // Function to check exact "Dwelling Address" label (case-insensitive)
      const isExactDwellingLabel = (text) => text?.trim().toLowerCase() === 'dwelling address';

      // Find index of "Dwelling Address" node
      let dwellingIndex = -1;
      for (let i = 0; i < textNodes.length; i++) {
        console.log("Checking text node:", textNodes.length);
        if (isExactDwellingLabel(textNodes[i].textContent)) {
          dwellingIndex = i;
          break;
        }
      }

      const scannedIndices = new Set();

      // Step 1: Scan 10 nodes after Dwelling Address label (if found)
      if (dwellingIndex >= 0) {
        for (let i = dwellingIndex; i < Math.min(dwellingIndex + 10, textNodes.length); i++) {
          console.log("Checking text node 2:", textNodes.length);
          scannedIndices.add(i);
          const text = textNodes[i].textContent.trim();
          if (!text) continue;

          const matches = text.match(addressRegex);
          if (matches) {
            matches.forEach((match) => results.add(normalizeAddress(match)));
          }
        }
      }

      // Step 2: Scan remaining text nodes excluding those already scanned
      for (let i = 0; i < textNodes.length; i++) {
        if (scannedIndices.has(i)) continue;

        const text = textNodes[i].textContent.trim();
        if (text.length > 100) continue;  // Skip overly long text nodes (like scripts)
        if (!text) continue;

        let matches = false;
        const zipRegex = /\b\d{5}\b/;
        if (text.match(zipRegex)) {
          matches = text.match(addressRegex);
        }
        if (matches) {
          matches.forEach((match) => results.add(normalizeAddress(match)));
        }
      }

      // Step 3: Handle 'lightning-formatted-address' elements
      const addressElements = document.querySelectorAll('lightning-formatted-address');
      addressElements.forEach((element) => {
        const addressParts = Array.from(element.querySelectorAll('div')).map(div => div.textContent.trim()).join(', ');
        const matches = addressParts.match(addressRegex);
        if (matches) {
          matches.forEach((match) => results.add(normalizeAddress(match)));
        }
      });

      return Array.from(results);
    }
  }, (results) => {
    if (chrome.runtime.lastError || !results || !results[0]) {
      stopFlashing();
      return;
    }

    const addresses = results[0].result;
    if (addresses && addresses.length > 0) {
      startFlashing();
    } else {
      stopFlashing();
    }
  });
}






chrome.tabs.onActivated.addListener(({ tabId }) => {
  checkTabForAddresses(tabId);
});

chrome.tabs.onUpdated.addListener((tabId, changeInfo, tab) => {
  if (tab.active && changeInfo.status === 'complete') {
    checkTabForAddresses(tabId);
  }
});


let latestDownloadUrl = null; // Make sure this exists globally
chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
  // let isNotified = false;
  if (message.action === "checkVersion") {
    // if(!isNotified) {
      //checkVersion();
    // }
  }
});


function checkVersion() {
  const currentVersion = chrome.runtime.getManifest().version;

  fetch("https://pti.agency/extension-version.json?cache=no-cache")
    .then(res => res.json())
    .then(data => {
      const latestVersion = data.version;
      const releasenotes = data.releasenotes || "";

      latestDownloadUrl = data.download_url;

      if (!latestDownloadUrl) {
        console.error("download_url missing in JSON");
        return;
      }

      // Create a fresh unique notification ID every time
      const notificationId = "versionCheck_" + Date.now();

      if (currentVersion !== latestVersion) {
        chrome.notifications.create(notificationId, {
          type: "basic",
          iconUrl: "icon_active_no_background.png",
          title: "New Version Available!",
          message: `Click to download v${latestVersion}\n${releasenotes}`,
          priority: 2
        });

        // Save update info in local storage
        // chrome.storage.local.set({
        //   updateAvailable: true,
        //   latestVersion: latestVersion,
        //   releasenotes: releasenotes
        // });

        // // Notify popup (if it is open)
        // chrome.runtime.sendMessage({
        //   type: "UPDATE_AVAILABLE",
        //   latestVersion,
        //   releasenotes
        // });

        // isNotified = true;
      } else {
        // Clear update info
        // chrome.storage.local.set({
        //   updateAvailable: false
        // });

        // // Tell popup to REMOVE the message
        // chrome.runtime.sendMessage({
        //   type: "NO_UPDATE"
        // });
        // chrome.notifications.create(notificationId, {
        //   type: "basic",
        //   iconUrl: "icon_active_no_background.png",
        //   title: "Up to date",
        //   message: `Current version: ${currentVersion}`,
        //   priority: 0
        // });
      }
    })
    .catch(err => {
      console.error("Error checking version:", err);
    });
}

// Notification click = open download
// chrome.notifications.onClicked.addListener((notificationId) => {
//   if (notificationId.startsWith("versionCheck_") && latestDownloadUrl) {
//     chrome.tabs.create({ url: latestDownloadUrl });
//   }
//   //isNotified = false; // Reset notification flag after click
// });


chrome.notifications.onClicked.addListener((notificationId) => {
  if (!notificationId.startsWith("versionCheck_")) return;

  chrome.storage.local.get(["ENV"], (result) => {
    // Use stored download URL if you want environment-based logic
    chrome.tabs.create({
      url: "https://pti.agency/ptintelliquote/"
    });
  });
});

