// popup.js
document.addEventListener('DOMContentLoaded', () => {
  // populateAddressesAndInsurance();

  document.getElementById('submitButton').addEventListener('click', (event) => {
    event.preventDefault();
    passDataToAPI();
  });

  document.getElementById('logout_btn').addEventListener('click', (event) => {
    event.preventDefault();
    logoutUser();
  });

  // Check cookies and show/hide address wrapper based on login status
chrome.runtime.sendMessage({ action: "checkCookie" }, (response) => {
  if (response.exists) {
    showAddress();
    populateAddressesAndInsurance();
  } else {
    hideAddress();
  }
});

});


function logoutUser() {
  // Ask background script to get cookie values
    chrome.runtime.sendMessage({ action: "checkCookie" }, (response) => {
      let authHeader = {};

      if (response.exists && response.cookies) {
        // Use the first cookie value directly as the Authorization header value
        const firstCookieName = Object.keys(response.cookies)[0];
        const firstCookieValue = response.cookies[firstCookieName];
        authHeader = {
          'Authorization': firstCookieValue
        };
      }

      fetch(API_LOGOUT_URL, {
        method: 'POST',  
        headers: authHeader
      })
      .then(response => {
        if (!response.ok) {
          throw new Error(`Logout failed with status: ${response.status}`);
        }
        return response.json();
      })
      .then(data => {
        chrome.runtime.sendMessage({ action: "reloadExtension" });
        // Optionally redirect or update UI
        // window.location.href = '/login';
      })
      .catch(error => {
        console.error('Error during logout:', error);
      });
    });
}


// Function to extract addresses from the page
// function extractAddressesByState() {
//   const stateAbbr = [
//     'AL','AK','AZ','AR','CA','CO','CT','DE','FL','GA','HI','ID','IL','IN','IA','KS','KY','LA','ME','MD','MA','MI','MN',
//     'MS','MO','MT','NE','NV','NH','NJ','NM','NY','NC','ND','OH','OK','OR','PA','RI','SC','SD','TN','TX','UT','VT','VA',
//     'WA','WV','WI','WY'
//   ];

//   const addressRegex = new RegExp(
//     `\\d+\\s+[^\\n,]+,?\\s+[^\\n,]+,?\\s+(?:${stateAbbr.join('|')})(?:,)?\\s+\\d{5}`,
//     'gi'
//   );

//   const results = new Set();
//   const allElements = Array.from(document.querySelectorAll('p, span, div, li, address'));
//   console.log("All elements found:", allElements.length);
//   const isExactDwellingLabel = (text) =>
//     text?.trim().toLowerCase() === 'dwelling address';

//   // Step 1: Find index of "Dwelling"
//   let dwellingIndex = -1;
//   for (let i = 0; i < allElements.length; i++) {
//     const text = allElements[i].innerText?.trim();
//     if (text && isExactDwellingLabel(text)) {
//       dwellingIndex = i;
//       break;
//     }
//   }

//   const scannedIndices = new Set();

//   // Step 2: Scan next 10 elements after dwelling label (if found)
//   if (dwellingIndex >= 0) {
//     for (let i = dwellingIndex; i < Math.min(dwellingIndex + 10, allElements.length); i++) {
//       scannedIndices.add(i);
//       const text = allElements[i].innerText?.trim();
//       if (!text) continue;

//       // Inside both the dwelling scan and full-page scan
// const matches = text.match(addressRegex);
// if (matches) {
//   matches.forEach((match) => {
//     if (!match.toLowerCase().includes('dwelling')) {
//       results.add(match.trim());
//     }
//   });
// }

//     }
//   }

//   // Step 3: Scan the rest of the page (excluding already scanned)
//   for (let i = 0; i < allElements.length; i++) {
//     if (scannedIndices.has(i)) continue; // skip previously scanned ones
//     const text = allElements[i].innerText?.trim();
//     if (!text) continue;

//     // Inside both the dwelling scan and full-page scan
// const matches = text.match(addressRegex);
// if (matches) {
//   matches.forEach((match) => {
//     if (!match.toLowerCase().includes('dwelling')) {
//       results.add(match.trim());
//     }
//   });
// }

//   }

//   return Array.from(results);
// }

// function extractAddressesByState() {
//   const stateAbbr = [
//     'AL','AK','AZ','AR','CA','CO','CT','DE','FL','GA','HI','ID','IL','IN','IA','KS','KY','LA','ME','MD','MA','MI','MN',
//     'MS','MO','MT','NE','NV','NH','NJ','NM','NY','NC','ND','OH','OK','OR','PA','RI','SC','SD','TN','TX','UT','VT','VA',
//     'WA','WV','WI','WY'
//   ];

//   const addressRegex = new RegExp(
//     `\\d+\\s+[^\\n,]+,?\\s+[^\\n,]+,?\\s+(?:${stateAbbr.join('|')})(?:,)?\\s+\\d{5}`,
//     'gi'
//   );

//   const results = new Set();
//   const allElements = Array.from(document.querySelectorAll('p, span, div, li, address'));

//   // Early exit if too many elements
//   if (allElements.length > 5000) {
//     console.warn("Too many elements on the page, skipping address extraction.");
//     return [];
//   }

//   const isExactDwellingLabel = (text) =>
//     text?.trim().toLowerCase() === 'dwelling address';

//   let dwellingIndex = -1;
//   for (let i = 0; i < allElements.length; i++) {
//     const text = allElements[i].innerText?.trim();
//     if (text && isExactDwellingLabel(text)) {
//       dwellingIndex = i;
//       break;
//     }
//   }

//   const scannedIndices = new Set();

//   if (dwellingIndex >= 0) {
//     for (let i = dwellingIndex; i < Math.min(dwellingIndex + 10, allElements.length); i++) {
//       scannedIndices.add(i);
//       const text = allElements[i].innerText?.trim();
//       if (!text) continue;

//       const matches = text.match(addressRegex);
//       if (matches) {
//         matches.forEach((match) => {
//           if (!match.toLowerCase().includes('dwelling')) {
//             results.add(match.trim());
//           }
//         });
//       }
//     }
//   }

//   for (let i = 0; i < allElements.length; i++) {
//     if (scannedIndices.has(i)) continue;
//     const text = allElements[i].innerText?.trim();
//     if (!text) continue;

//     const matches = text.match(addressRegex);
//     if (matches) {
//       matches.forEach((match) => {
//         if (!match.toLowerCase().includes('dwelling')) {
//           results.add(match.trim());
//         }
//       });
//     }
//   }

//   return Array.from(results);
// }

// function extractAddressesByState() {
//   const stateAbbr = [
//     'AL','AK','AZ','AR','CA','CO','CT','DE','FL','GA','HI','ID','IL','IN','IA','KS','KY','LA','ME','MD','MA','MI','MN',
//     'MS','MO','MT','NE','NV','NH','NJ','NM','NY','NC','ND','OH','OK','OR','PA','RI','SC','SD','TN','TX','UT','VT','VA',
//     'WA','WV','WI','WY'
//   ];

//   // US address pattern: number, street, city, state, ZIP
//   const addressRegex = new RegExp(
//   `\\d+\\s+[^\\n,]+,\\s+[^\\n,]+,?\\s+(?:${stateAbbr.join('|')})\\s+\\d{5}`,
//   'gi'
// );


//   const results = new Set();

//   // XPath to target common containers that may hold addresses
//   const xpath = "//text()[normalize-space(.) != '']";
//   const iterator = document.evaluate(xpath, document, null, XPathResult.ORDERED_NODE_ITERATOR_TYPE, null);

//   let node = iterator.iterateNext();
//   while (node) {
//     const text = node.textContent.trim();
//     if (text.length > 20) {
//       const matches = text.match(addressRegex);
//       if (matches) {
//         matches.forEach((match) => results.add(match.trim()));
//       }
//     }
//     node = iterator.iterateNext();
//   }

//   return Array.from(results);
// }

function extractAddressesByState() {
  const stateAbbr = [
        'AL', 'AK', 'AZ', 'AR', 'CA', 'CO', 'CT', 'DE', 'FL', 'GA', 'HI', 'ID', 'IL', 'IN', 'IA', 'KS', 'KY', 'LA', 'ME', 'MD', 'MA', 'MI', 'MN',
        'MS', 'MO', 'MT', 'NE', 'NV', 'NH', 'NJ', 'NM', 'NY', 'NC', 'ND', 'OH', 'OK', 'OR', 'PA', 'RI', 'SC', 'SD', 'TN', 'TX', 'UT', 'VT', 'VA',
        'WA', 'WV', 'WI', 'WY'
      ];

      // US address pattern: number, street, city, state, ZIP
      const addressRegex = new RegExp(
        `(\\d+\\s+[^,\\n]+(?:\\s*,?\\s*Suite\\s+\\d+)?[,\\s]*[^,\\n]+[,\\s]*(?:${stateAbbr.join('|')})[,\\s]*\\d{5}(?:[,\\s]*USA)?)`,
        'gi'
      );

      const results = new Set();

      // Normalize address: lowercase, trim, remove trailing punctuation like '.' or ',' 
      function normalizeAddress(addr) {
        return addr.trim().replace(/[.,]$/, '');
      }

      // XPath to get non-empty text nodes
      const xpath = "//text()[normalize-space(.) != '']";
      const iterator = document.evaluate(xpath, document, null, XPathResult.ORDERED_NODE_ITERATOR_TYPE, null);

      // Collect all text nodes into an array for indexed access
      const textNodes = [];
      let node = iterator.iterateNext();
      while (node) {
        textNodes.push(node);
        node = iterator.iterateNext();
      }

      // Function to check exact "Dwelling Address" label (case-insensitive)
      const isExactDwellingLabel = (text) => text?.trim().toLowerCase() === 'dwelling address';

      // Find index of "Dwelling Address" node
      let dwellingIndex = -1;
      for (let i = 0; i < textNodes.length; i++) {
        console.log("Checking text node:", textNodes.length);
        if (isExactDwellingLabel(textNodes[i].textContent)) {
          dwellingIndex = i;
          break;
        }
      }

      const scannedIndices = new Set();

      // Step 1: Scan 10 nodes after Dwelling Address label (if found)
      if (dwellingIndex >= 0) {
        for (let i = dwellingIndex; i < Math.min(dwellingIndex + 10, textNodes.length); i++) {
          console.log("Checking text node 2:", textNodes.length);
          scannedIndices.add(i);
          const text = textNodes[i].textContent.trim();
          if (!text) continue;

          const matches = text.match(addressRegex);
          if (matches) {
            matches.forEach((match) => results.add(normalizeAddress(match)));
          }
        }
      }

      // Step 2: Scan remaining text nodes excluding those already scanned
      for (let i = 0; i < textNodes.length; i++) {
        if (scannedIndices.has(i)) continue;

        const text = textNodes[i].textContent.trim();
        if (text.length > 100) continue;  // Skip overly long text nodes (like scripts)
        if (!text) continue;

        let matches = false;
        const zipRegex = /\b\d{5}\b/;
        if (text.match(zipRegex)) {
          matches = text.match(addressRegex);
        }
        if (matches) {
          matches.forEach((match) => results.add(normalizeAddress(match)));
        }
      }

      // Step 3: Handle 'lightning-formatted-address' elements
      const addressElements = document.querySelectorAll('lightning-formatted-address');
      addressElements.forEach((element) => {
        const addressParts = Array.from(element.querySelectorAll('div')).map(div => div.textContent.trim()).join(', ');
        const matches = addressParts.match(addressRegex);
        if (matches) {
          matches.forEach((match) => results.add(normalizeAddress(match)));
        }
      });

      return Array.from(results);
}








let allAddresses = [];
let selectedAddresses = new Map(); // key: row index, value: selected address

// Function to populate addresses and insurance types in the dropdowns
function populateAddressesAndInsurance() {
  const loader = document.getElementById('loader');
  if (loader) loader.style.display = 'block'; // Show loader

  chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
    chrome.scripting.executeScript({
      target: { tabId: tabs[0].id },
      func: extractAddressesByState
    }, (results) => {
      if (loader) loader.style.display = 'none';
      allAddresses = results[0].result;
      const container = document.getElementById('dropdownContainer');
      container.innerHTML = '';

      const addMoreBtn = document.getElementById('addMore');
      if (addMoreBtn) addMoreBtn.style.display = 'none';

      if (allAddresses.length === 0) {
        container.textContent = 'No addresses found.';
        document.querySelector('.submit-btn-wrap').style.display = 'none';
        
        // Tell background to stop flashing
        chrome.runtime.sendMessage({ action: 'stopFlashing' });
        return;
      }

      if(document.querySelectorAll('.dropdown-row').length === allAddresses.length) {
            addMoreBtn.style.display = 'none';
      }

      // Tell background to start flashing

      chrome.runtime.sendMessage({ action: 'startFlashing' });

      document.querySelector('.submit-btn-wrap').style.display = 'block';

      // Show "Add More" button if multiple addresses
      if (allAddresses.length > 1 && addMoreBtn) {
        addMoreBtn.style.display = 'inline-block';
        addMoreBtn.onclick = () => {
          const currentCount = document.querySelectorAll('.dropdown-row').length;
          addAddressRow(currentCount);
        };
      }

      addAddressRow(0);

      // allAddresses.forEach((_, index) => {
      //   const row = document.createElement('div');
      //   row.className = 'dropdown-row';

      //   // Add a condition to display/hide rows based on the index
      //   if (index === 0) {
      //     row.classList.add('show'); // Add class 'show' for the first row
      //   } else {
      //     row.classList.add('hide'); // Add class 'hide' for other rows
      //   }

      //   const insuranceSelectWrap1 = document.createElement('div');
      //   insuranceSelectWrap1.className = 'insuranceSelectWrap';

      //   const addressSelectLabel = document.createElement('label');
      //   addressSelectLabel.innerText =  `Address:`;


      //   // Address dropdown
      //   const addressSelect = document.createElement('select');
      //   addressSelect.className = 'addressDropdown form-select';
      //   addressSelect.dataset.row = index;

      //   updateAddressOptions(addressSelect, null);

      //   addressSelect.addEventListener('change', () => {
      //     const rowIdx = parseInt(addressSelect.dataset.row);
      //     const prevSelected = selectedAddresses.get(rowIdx);
      //     const newSelected = addressSelect.value;

      //     // Update selection
      //     selectedAddresses.set(rowIdx, newSelected);

      //     // Refresh other dropdowns
      //     document.querySelectorAll('.addressDropdown').forEach((dropdown) => {
      //       const currentRow = parseInt(dropdown.dataset.row);
      //       if (currentRow !== rowIdx) {
      //         const currentValue = selectedAddresses.get(currentRow) || null;
      //         updateAddressOptions(dropdown, currentValue);
      //       }
      //     });
      //   });

      //   const insuranceSelectWrap2 = document.createElement('div');
      //   insuranceSelectWrap2.className = 'insuranceSelectWrap';

      //   const insuranceSelectLabel = document.createElement('label');
      //   insuranceSelectLabel.for =  `insurance-${index}`;
      //   insuranceSelectLabel.innerText =  `Insurance Types:`;

      //   // Insurance dropdown
      //   const insuranceSelect = document.createElement('select');
      //   insuranceSelect.className = 'insuranceDropdown form-select';
      //   insuranceSelect.id = `insurance-${index}`;
      //   insuranceSelect.multiple = true;
      //   insuranceSelect.size = 4;

      //   insuranceSelectWrap1.appendChild(addressSelectLabel);
      //   insuranceSelectWrap1.appendChild(addressSelect);
      //   insuranceSelectWrap2.appendChild(insuranceSelectLabel);
      //   insuranceSelectWrap2.appendChild(insuranceSelect);
      //   row.appendChild(insuranceSelectWrap1);
      //   row.appendChild(insuranceSelectWrap2);
      //   container.appendChild(row);
      //   populateInsuranceTypes(insuranceSelect).then(() => {
      //     $(insuranceSelect).select2({
      //       placeholder: "Select insurance types",
      //       width: '100%',
      //       closeOnSelect: true,
      //       dropdownPosition: 'below'
      //     });
      //   });
      // });
    });
  });
}


function addAddressRow(index) {
  const row = document.createElement('div');
  row.className = 'dropdown-row';

  const insuranceSelectWrap1 = document.createElement('div');
  insuranceSelectWrap1.className = 'insuranceSelectWrap';

  const addressSelectLabel = document.createElement('label');
  addressSelectLabel.innerText = 'Address:';

  const addressSelect = document.createElement('select');
  addressSelect.className = 'addressDropdown form-select';
  addressSelect.dataset.row = index;

  updateAddressOptions(addressSelect, null);

  addressSelect.addEventListener('change', () => {
    const rowIdx = parseInt(addressSelect.dataset.row);
    const newSelected = addressSelect.value;
    selectedAddresses.set(rowIdx, newSelected);

    document.querySelectorAll('.addressDropdown').forEach((dropdown) => {
      const currentRow = parseInt(dropdown.dataset.row);
      const currentValue = selectedAddresses.get(currentRow) || null;
      updateAddressOptions(dropdown, currentValue);
    });
  });

  insuranceSelectWrap1.appendChild(addressSelectLabel);
  insuranceSelectWrap1.appendChild(addressSelect);

  const insuranceSelectWrap2 = document.createElement('div');
  insuranceSelectWrap2.className = 'insuranceSelectWrap';

  const insuranceSelectLabel = document.createElement('label');
  insuranceSelectLabel.setAttribute('for', `insurance-${index}`);
  insuranceSelectLabel.innerText = 'Insurance Types:';

  const insuranceSelect = document.createElement('select');
  insuranceSelect.className = 'insuranceDropdown form-select';
  insuranceSelect.id = `insurance-${index}`;
  insuranceSelect.multiple = true;
  insuranceSelect.size = 4;

  insuranceSelectWrap2.appendChild(insuranceSelectLabel);
  insuranceSelectWrap2.appendChild(insuranceSelect);

  row.appendChild(insuranceSelectWrap1);
  row.appendChild(insuranceSelectWrap2);

  const container = document.getElementById('dropdownContainer');
  container.appendChild(row);

  populateInsuranceTypes(insuranceSelect).then(() => {
    $(insuranceSelect).select2({
      placeholder: "Select insurance types",
      width: '100%',
      closeOnSelect: true,
      dropdownPosition: 'below'
    });
  });
}

// Function to update address options in the dropdown
function updateAddressOptions(dropdown, selectedValue) {
  const usedAddresses = Array.from(selectedAddresses.values()).filter(val => val !== selectedValue);
  dropdown.innerHTML = '';

  const defaultOption = document.createElement('option');
  defaultOption.value = '';
  defaultOption.textContent = '-- Select address --';
  dropdown.appendChild(defaultOption);

  allAddresses.forEach(address => {
    const option = document.createElement('option');
    option.value = address;
    option.textContent = address;
    if (usedAddresses.includes(address)) {
      option.disabled = true;
    }
    dropdown.appendChild(option);
  });

  // Re-set value to selected one (if any)
  if (selectedValue) {
    dropdown.value = selectedValue;
  }
}


// Function to populate insurance types in the dropdown
function populateInsuranceTypes(dropdownElement) {
  return new Promise((resolve) => {
    dropdownElement.innerHTML = '';
    const loadingOption = document.createElement('option');
    loadingOption.textContent = 'Loading...';
    loadingOption.disabled = true;
    dropdownElement.appendChild(loadingOption);

    // Ask background script to get cookie values
    chrome.runtime.sendMessage({ action: "checkCookie" }, (response) => {
      let authHeader = {};

      if (response.exists && response.cookies) {
        // Use the first cookie value directly as the Authorization header value
        const firstCookieName = Object.keys(response.cookies)[0];
        const firstCookieValue = response.cookies[firstCookieName];
        authHeader = {
          'Authorization': firstCookieValue
        };
      }

      // Fetch API with Authorization header (raw cookie value)
      fetch(API_URL, {
        headers: authHeader
      })
        .then(response => {
          if (!response.ok) throw new Error(`HTTP error! status: ${response.status}`);
          return response.json();
        })
        .then(data => {
          dropdownElement.innerHTML = '';
          if (data.status && Array.isArray(data.items)) {
            if (data.items.length === 0) {
              const option = document.createElement('option');
              option.textContent = 'No insurance types available.';
              dropdownElement.appendChild(option);
            } else {
              data.items.forEach(item => {
                const option = document.createElement('option');
                option.value = item;
                option.textContent = item;
                dropdownElement.appendChild(option);
              });
            }
          } else {
            const option = document.createElement('option');
            option.textContent = 'Error loading insurance types';
            dropdownElement.appendChild(option);
          }
          resolve();
        })
        .catch(error => {
          console.error('Failed to fetch insurance types:', error);
          dropdownElement.innerHTML = '';
          const option = document.createElement('option');
          option.textContent = 'Error loading insurance types';
          dropdownElement.appendChild(option);
          resolve();
        });
    });
  });
}

// Function to pass data to API and handle responses
function passDataToAPI() {
  const rows = document.querySelectorAll('.dropdown-row');
  const requests = [];

  const formErrors = document.getElementById('formErrors');
  formErrors.textContent = '';

  const insuredNameInput = document.getElementById('insuredName');
  const insuredName = insuredNameInput?.value.trim();

  if (!insuredName) {
    formErrors.textContent = 'Please enter the insured name.\n';
    return;
  }

  rows.forEach((row, rowIndex) => {
    const addressSelect = row.querySelector('.addressDropdown');
    const address = addressSelect?.value;

    const selectedOptions = Array.from(row.querySelector('.insuranceDropdown')?.selectedOptions || []);
    const insurances = selectedOptions.map(option => option.value);

    if (!address || insurances.length === 0) {
      return;
    }

    insurances.forEach((insurance) => {
      const url = `${API_ADDRESS_URL}?address=${encodeURIComponent(address)}&insuranceType=${encodeURIComponent(insurance)}&insuredName=${encodeURIComponent(insuredName)}`;
      requests.push({ rowIndex, url });
    });
  });

  if (requests.length === 0) {
    formErrors.textContent = 'No valid rows to submit. Please fill in at least one complete row.';
    return;
  }

  const submitButton = document.getElementById('submitButton');
  submitButton.disabled = true;
  const originalText = submitButton.textContent;
  submitButton.textContent = 'Submitting...';

  Promise.all(
    requests.map(({ rowIndex, url }) =>
      fetch(url)
        .then(res => res.json())
        .then(data => ({ rowIndex, data }))
        .catch(err => ({ rowIndex, data: { error: err.message } }))
    )
  ).then(responses => {
    responses.forEach(({ rowIndex, data }) => {
      if (data.status && data.url) {
        chrome.tabs.create({ url: data.url });
      } else {
        formErrors.textContent += `Row ${rowIndex + 1}: ${data.message || data.error || 'API error or network issue'}\n`;
      }
    });

    submitButton.disabled = false;
    submitButton.textContent = originalText;
  }).catch(error => {
    console.error('Batch fetch error:', error);
    formErrors.textContent = 'Network error occurred.';
    submitButton.disabled = false;
    submitButton.textContent = originalText;
  });
}



// Function to show address wrapper and hide header link
function showAddress() {
  const addressWrapper = document.getElementById("address-wrapper");
  const addressHeader = document.getElementById("address-header");

  if (addressWrapper) addressWrapper.style.display = "block";
  if (addressHeader) addressHeader.style.display = "none";
  
}

// Function to hide address wrapper and reset header link
function hideAddress() {
  const addressWrapper = document.getElementById("address-wrapper");
  const addressHeaderLink = document.querySelector(".address-header .login-text a");

  if (addressHeaderLink) addressHeaderLink.href = API_AUTH_URL;
  if (addressWrapper) addressWrapper.style.display = "none";

}
